		page	,132
                title   "PCjr 83 (or 101) Key Keyboard Patch"
;
;    by Fred P. Brucker  (contributed to the public domain)


;  When an adapter is used on a PCjr to attach a standard PC or
;  clone keyboard (83 or 101 keys), certain key combinations will
;  produce undesirable results.  For example if you type Alt-[ or
;  Alt-] you will see | or ~ respectively.  These are left over
;  from the PCjr's 62 key keyboard, which has no other way to
;  produce these characters.  Some programs use these key combina-
;  tions for special purposes and if they see a |, for example,
;  they have no way of knowing which keys were pressed.
;
;  This program will eliminated this problem.  Simply run it in
;  your AUTOEXEC.BAT file.


bios_data       segment at 40h
 
		org	17h
kb_flag		db	?
alt_shift	equ	08h		; alt key held
ctl_shift	equ	04h		; ctrl key held
left_shift	equ	02h		; left shift held
right_shift	equ	01h		; right shift held
kb_flag_1	db	?
hold_state	equ	08h		; hold is on
off_hold_state	equ	0f7h		; turn off hold state
 
bios_data	ends
 
nmi_port        equ     0a0h            ; nmi port address

code            segment
		org	100h
		assume	cs:code,ds:nothing,es:nothing,ss:nothing
 
num_key		equ	45h		; numlock key
ps_key		equ	37h		; prtsc key
scrl_key	equ     46h		; scroll lock key
 
start:
      		jmp	init
 
;       Code to replace interrupt 48; must handle shift+prtsc and
;         ctrl+numlock  (based on BIOS routines).
;       Called from interrupt 2 (NMI), no registers need be saved.
i48:
		sti
		mov	bx,bios_data
		mov	ds,bx
		assume	ds:bios_data
 
		cmp	al,num_key
		jne	fn30
		test	kb_flag,ctl_shift
		jz	cont_int
		test	kb_flag,alt_shift
		jnz	cont_int
   		test	kb_flag_1,hold_state
		jnz	fn20
fn5:
    		or	kb_flag_1,hold_state
		in	al,nmi_port
fn10:
		test	kb_flag_1,hold_state
		jnz	fn10
fn20:
		iret
fn30:
     		cmp	al,ps_key
                jne     cont_int
		test	kb_flag,left_shift+right_shift
		jz	cont_int
		test	kb_flag,ctl_shift
		jnz	cont_int
    		test	kb_flag_1,hold_state
                jz      fn40
		and	kb_flag_1,off_hold_state
		iret
fn40:
		in	al,nmi_port
		int	5
		add	sp,3*2
		pop	ds
		pop	dx
		pop	bx
		pop	si
		pop	es
		pop	cx
		pop	ax
		pop	di
		iret
 
cont_int:
		out	60h,al
		int	9
		iret
 
ressiz	   	equ	($-start+100h)/16+1  ; size of resident code in paras
 
; ---------------------------------------------------------------------
; Re-vector interrupt and make program resident (non-resident code)
; ---------------------------------------------------------------------
 
		assume	cs:code,ds:code,es:code,ss:code
 
;       establish new interrupt vector 48
 
init:
                mov     dx,offset i48
                mov     ax,2548h
                int     21h
 
;	leave program resident
 
		mov	dx,ressiz
		mov	ax,3100h
		int	21h
 
code		ends
		end	start
